/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.custinfo;

import com.ibm.hwmca.base.custinfo.CustomerInfoBean;
import com.ibm.hwmca.base.custinfo.CustomerInfoConstants;
import com.ibm.hwmca.base.custinfo.CustomerInfoData;
import com.ibm.hwmca.base.custinfo.CustomerInfoManager;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.rcs.conndata.ConnectionInfoManager;
import com.ibm.hwmca.fw.tasklet.DisplayAreaDescriptor;
import com.ibm.hwmca.fw.tasklet.DisplayAreaDescriptorData;
import com.ibm.hwmca.fw.tasklet.DisplayAreaDescriptorDelegate;
import com.ibm.hwmca.fw.tasklet.PanelTasklet;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.Trace;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class CustomerInfoTasklet
extends PanelTasklet
implements CustomerInfoConstants {
    private static final String TRACE_MASKT = "XSETCITT";
    private static final String TRACE_MASKF = "XSETCITF";
    private static final String TRACE_MASKD = "XSETCITD";
    private static final FrameworkClassLogInfo classLogInfo = new FrameworkClassLogInfo(85, "CustInfoTskl");
    private CustomerInfoBean custInfoBean;
    private CustomerInfoData custInfoData;
    private List availCountries;
    private Map availSubdivisions;

    public CustomerInfoTasklet() {
        Trace.trace(TRACE_MASKT, "<> CustomerInfoTasklet()");
    }

    public void init() throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> init()");
        Trace.trace(TRACE_MASKT, "<- init()");
    }

    public void service(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> service(" + request + ", " + response + ")");
        try {
            if (request.isInitialRequest()) {
                this.custInfoBean = new CustomerInfoBean();
                this.custInfoBean.setBeanName("CustomerInfoBean");
                CustomerInfoManager custInfoMgr = CustomerInfoManager.getCustomerInfoManager();
                this.custInfoData = custInfoMgr.getCustomerInfo();
                Trace.trace(TRACE_MASKF, this.custInfoData.toString());
                Locale locale = this.clientInformation.getLocale();
                ConnectionInfoManager connInfoMgr = ConnectionInfoManager.getConnectionInfoManager();
                this.availCountries = connInfoMgr.getDisplayableCountries(locale);
                this.availSubdivisions = connInfoMgr.getDisplayableSubdivisions(locale);
                DisplayAreaDescriptorData custInfoPanel = new DisplayAreaDescriptorData("com.ibm.hwmca.base.custinfo.res.CustomerInfoRes", "CustomerInfoPanel", this.custInfoBean, null, null);
                DisplayAreaDescriptorDelegate adminTab = new DisplayAreaDescriptorDelegate("com.ibm.hwmca.base.custinfo.AdministratorTasklet", null);
                adminTab.setMountPoint("InformationTPane");
                DisplayAreaDescriptorDelegate systemTab = new DisplayAreaDescriptorDelegate("com.ibm.hwmca.base.custinfo.SystemTasklet", null);
                systemTab.setMountPoint("InformationTPane");
                DisplayAreaDescriptorDelegate acctTab = new DisplayAreaDescriptorDelegate("com.ibm.hwmca.base.custinfo.AccountTasklet", null);
                acctTab.setMountPoint("InformationTPane");
                response.replace(custInfoPanel, new DisplayAreaDescriptor[]{adminTab, systemTab, acctTab});
            } else if (request.isDisposed() || request.isCanceled()) {
                response.terminate();
            } else {
                String source = (String)request.getData("Source");
                if (source == null) {
                    source = "";
                }
                Trace.trace(TRACE_MASKF, "source=" + source);
                if (source.equals("")) {
                    Trace.trace(TRACE_MASKF, "Unspecified source");
                    response.noAction();
                } else if (source.equals("CustomerInfoPanel")) {
                    this.serviceCustomerInfoPanel(request, response);
                } else {
                    Trace.trace(TRACE_MASKF, "Unknown source");
                    response.noAction();
                }
            }
        }
        catch (TaskletException te) {
            throw te;
        }
        catch (Exception e) {
            throw new TaskletException(e);
        }
        Trace.trace(TRACE_MASKT, "<- service()");
    }

    public void logException(Throwable throwable) {
        Trace.trace(TRACE_MASKT, "-> logException(" + throwable + ")");
        new FrameworkLog(classLogInfo, 2068, throwable).log();
        Trace.trace(TRACE_MASKT, "<- logException()");
    }

    private void serviceCustomerInfoPanel(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> serviceCustomerInfoPanel()");
        String command = (String)request.getData("Command");
        if (command == null) {
            command = "";
        }
        Trace.trace(TRACE_MASKF, "command=" + command);
        if (command.equals("")) {
            Trace.trace(TRACE_MASKF, "Unspecified command");
            response.noAction();
        } else if (command.equals("Commit")) {
            CustomerInfoManager custInfoMgr = CustomerInfoManager.getCustomerInfoManager();
            custInfoMgr.setCustomerInfo(this.custInfoData);
            response.terminate();
        } else if (command.equals("Cancel")) {
            response.terminate();
        } else {
            Trace.trace(TRACE_MASKF, "Unknown command");
            response.noAction();
        }
        Trace.trace(TRACE_MASKT, "<- serviceCustomerInfoPanel()");
    }

    public CustomerInfoData getCustInfoData() {
        return this.custInfoData;
    }

    public List getAvailCountries() {
        return this.availCountries;
    }

    public Map getAvailSubdivisions() {
        return this.availSubdivisions;
    }
}

